function ConvertTo-VBE {
    param (
        [string]$InputFile,
        [string]$OutputFile
    )

    $ascii = @()
    for ($i = 9; $i -le 126; $i++) {
        $ascii += [char]$i
    }

    $map = "_@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ !" +
           '"#$%&''()*+,-./0123456789:;<=>?'

    $table = @{}
    for ($i = 0; $i -lt $ascii.Count; $i++) {
        $table[$ascii[$i]] = $map[$i]
    }

    $text = Get-Content $InputFile -Raw
    $encoded = ""

    foreach ($char in $text.ToCharArray()) {
        if ($table.ContainsKey($char)) {
            $encoded += $table[$char]
        } else {
            $encoded += $char
        }
    }

    $header = "#@~^"
    $footer = "==^#~@"

    Set-Content -Path $OutputFile -Value ($header + $encoded + $footer) -Encoding ASCII
}

# -------------------------------
# Automatyczne użycie katalogu skryptu
# -------------------------------

$scriptFolder = $PSScriptRoot   # katalog, gdzie jest .ps1
$inputFile  = Join-Path $scriptFolder "skrypt.vbs"
$outputFile = Join-Path $scriptFolder "skrypt.vbe"

ConvertTo-VBE -InputFile $inputFile -OutputFile $outputFile

Write-Host "Gotowe! Utworzono plik: $outputFile"
